<?php

namespace Daylight\Connector\Exact\Requests\Contacts;

use Daylight\Connector\Exact\Entities\Contact;
use Daylight\Connector\Exact\Mappers\ContactMapper;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;

class GetContactRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected ContactMapper $contactMapper,
        protected array $options = []
    ) {}

    public function resolveEndpoint(): string
    {
        $guidFilter = isset($this->options['id'])
            ? "(guid'{$this->options['id']}')"
            : null;

        return '/api/v1/'.config('services.exact.division').'/CRM/Contacts'.$guidFilter;
    }

    public function defaultQuery(): array
    {
        return array_filter([
            '$select' => implode(',', [
                'ID',
                //                'Timestamp',
                'Account',
                'AccountIsCustomer',
                'Email',
                'EndDate',
                'FirstName',
                'IsAnonymised',
                'IsMainContact',
                'Language',
                'LastName',
                'MiddleName',
                'Mobile',
                'StartDate',
            ]),
        ]);
    }

    public function createDtoFromResponse(Response $response): ?Contact
    {
        return $this->contactMapper->map($response->json('d'));
    }
}
