<?php

namespace Daylight\Connector\Exact\Requests\Orders;

use Daylight\Connector\Exact\Entities\PaginatedResource;
use Daylight\Connector\Exact\Mappers\OrderMapper;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;

class GetOrdersRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected OrderMapper $orderMapper,
        protected array $options = []
    ) {}

    public function resolveEndpoint(): string
    {
        return '/api/v1/'.config('services.exact.division').'/bulk/SalesOrder/SalesOrders';
    }

    public function defaultQuery(): array
    {
        return array_filter([
            '$expand' => 'SalesOrderLines',
            '$select' => implode(',', [
                'OrderID',
                'OrderNumber',
                'DeliveryAddress',
                'InvoiceTo',
                'PaymentReference',
                'OrderDate',
                'ApprovalStatus',
                'PaymentCondition',
                'ShippingMethod',
                'Status',
                'AmountFCExclVat',
                'AmountFC',
                'YourRef',
                'Remarks',
                'OrderedByContactPerson',
                'SalesOrderLines/ID',
                'SalesOrderLines/LineNumber',
                'SalesOrderLines/ItemDescription',
                'SalesOrderLines/Item',
                'SalesOrderLines/ItemCode',
                'SalesOrderLines/Quantity',
                'SalesOrderLines/NetPrice',
                'SalesOrderLines/VATCode',
                'SalesOrderLines/VATAmount',
            ]),
            //            '$top' => 25,
            '$skiptoken' => $this->options['skiptoken'] ?? null,
            //            '$filter' => 'OrderNumber eq 253434'
            //            '$filter' => 'OrderNumber eq 253208' // Toeslagen
            //            '$filter' => 'OrderNumber eq 223156' // Toeslagen maar meer
            //            '$filter' => 'OrderNumber eq 231343', // BTW Verlegd
            //            '$filter' => 'OrderNumber eq 253377' // Vezendkosten
        ]);
    }

    public function createDtoFromResponse(Response $response): PaginatedResource
    {
        $formattedResponse = $response->json('d');

        return new PaginatedResource(
            data: collect($formattedResponse['results'] ?? [])->map(function (array $item) {
                return $this->orderMapper->map($item);
            }),
            skipToken: $formattedResponse['__next'] ?? null,
        );
    }
}
