<?php

namespace Daylight\Connector\Exact\Requests\Products;

use Daylight\Connector\Exact\Entities\PaginatedResource;
use Daylight\Connector\Exact\Mappers\ProductChargeMapper;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;

class GetProductChargesRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected ProductChargeMapper $productChargeMapper,
        protected array $options = []
    ) {}

    public function resolveEndpoint(): string
    {
        return '/api/v1/'.config('services.exact.division').'/logistics/ItemChargeRelation';
    }

    public function defaultQuery(): array
    {
        return array_filter([
            '$select' => implode(',', [
                'ID',
                'Quantity',
                'Amount',
                'ChargeID',
                'ChargeCode',
                'ChargeDescription',
                'ItemID',
                'ChargeVATCode',
            ]),
            '$skiptoken' => $this->options['skiptoken'] ?? null,
        ]);
    }

    public function createDtoFromResponse(Response $response): PaginatedResource
    {
        $formattedResponse = $response->json('d');

        return new PaginatedResource(
            data: collect($formattedResponse['results'] ?? [])->map(function (array $item) {
                return $this->productChargeMapper->map($item);
            }),
            skipToken: $formattedResponse['__next'] ?? null,
        );
    }
}
