<?php

namespace Daylight\Connector\Exact\Resources;

use Daylight\Connector\Contracts\MapperInterface;
use Saloon\Http\BaseResource;
use Saloon\Http\Response;

class Products extends BaseResource
{
    public function all(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Products\\GetProductsRequest',
            $mapper,
            $options
        );
    }

    public function prices(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Products\\GetProductPricesRequest',
            $mapper,
            $options
        );
    }

    public function charges(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Products\\GetProductChargesRequest',
            $mapper,
            $options
        );
    }
}
