<?php

namespace Daylight\Connector\Exact\Entities;

use Carbon\Carbon;
use Daylight\Connector\Entities\Customer as BaseCustomer;
use Daylight\Connector\Exact\Entities\Casts\TimestampDateCast;
use Spatie\LaravelData\Attributes\MapInputName;
use Spatie\LaravelData\Attributes\WithCast;

class Customer extends BaseCustomer
{
    public function __construct(
        #[MapInputName('ID')]
        public string $id,

        #[MapInputName('Timestamp')]
        public ?int $timestamp,

        #[MapInputName('Name')]
        public string $name,

        #[MapInputName('Status')]
        public string $status,

        #[MapInputName('IsSales')]
        public bool $isSales = false,

        #[MapInputName('Blocked')]
        public bool $isBlocked = false,

        #[MapInputName('IsAnonymised')]
        public bool $isAnonymised = false,

        #[MapInputName('StartDate')]
        #[WithCast(TimestampDateCast::class)]
        public ?Carbon $startDate = null,

        #[MapInputName('EndDate')]
        #[WithCast(TimestampDateCast::class)]
        public ?Carbon $endDate = null,

        #[MapInputName('VATNumber')]
        public ?string $vatNumber = null,

        #[MapInputName('PriceList')]
        public ?string $priceListId = null,

        #[MapInputName('PaymentConditionSales')]
        public ?string $paymentConditionCode = null,

        #[MapInputName('SalesVATCode')]
        public ?string $taxCode = null,

        #[MapInputName('AddressLine1')]
        public ?string $addressLine1 = null,

        #[MapInputName('AddressLine2')]
        public ?string $addressLine2 = null,

        #[MapInputName('Postcode')]
        public ?string $postalCode = null,

        #[MapInputName('City')]
        public ?string $city = null,

        #[MapInputName('Country')]
        public ?string $country = null,

        #[MapInputName('ShippingMethod')]
        public ?string $shippingMethod = null,
    ) {
        //
    }

    public function shouldBeImported(): bool
    {
        return $this->status === 'C' && $this->isSales && ! $this->isAnonymised;
    }

    public function isPackageDelivery(): bool
    {
        return $this->shippingMethod === config('exact.package_delivery_id');
    }

    public function isActive(): bool
    {
        return ! $this->isBlocked && ($this->endDate === null || $this->endDate->greaterThanOrEqualTo(now()));
    }

    public function canPayOnInvoice(): bool
    {
        // @todo: map payment conditions
        return true;
    }
}
