<?php

namespace Daylight\Connector\Exact\Mappers;

use Daylight\Connector\Contracts\MapperInterface;
use Daylight\Connector\Exact\Entities\Address;

class AddressMapper implements MapperInterface
{
    public function map(array $data): Address
    {
        return Address::from($data);
    }

    public function mapWithAttributes(array $data, array $attributes = []): Address
    {
        return Address::from([
            ...$data,
            ...$attributes,
        ]);
    }
}
