<?php

namespace Daylight\Connector\Exact\Middleware;

use Daylight\Connector\Exact\TokenStorage;
use Illuminate\Support\Str;
use Saloon\Contracts\RequestMiddleware;
use Saloon\Http\PendingRequest;

class AuthenticateWithToken implements RequestMiddleware
{
    public function __construct(
        private readonly TokenStorage $tokenStorage
    ) {
        //
    }

    public function __invoke(PendingRequest $pendingRequest): void
    {
        if (Str::contains($pendingRequest->getUrl(), 'oauth2')) {
            return;
        }

        $pendingRequest->authenticate(
            authenticator: $this->tokenStorage->getAuthenticator()
        );
    }
}
