<?php

namespace Daylight\Connector\Exact\Requests\Orders;

use Daylight\Connector\Entities\Order;
use Daylight\Connector\Exact\Mappers\OrderMapper;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;

class GetOrderRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected OrderMapper $orderMapper,
        protected array $options = []
    ) {}

    public function resolveEndpoint(): string
    {
        $guidFilter = isset($this->options['id'])
            ? "(guid'{$this->options['id']}')"
            : null;

        return '/api/v1/'.config('services.exact.division').'/SalesOrder/SalesOrders'.$guidFilter;
    }

    public function defaultQuery(): array
    {
        return array_filter([
            '$expand' => 'SalesOrderLines',
            '$select' => implode(',', [
                'OrderID',
                'OrderNumber',
                'DeliveryAddress',
                'InvoiceTo',
                'PaymentReference',
                'OrderDate',
                'ApprovalStatus',
                'PaymentCondition',
                'ShippingMethod',
                'Status',
                'AmountFCExclVat',
                'AmountFC',
                'YourRef',
                'Remarks',
                'OrderedByContactPerson',
                'SalesOrderLines/ID',
                'SalesOrderLines/LineNumber',
                'SalesOrderLines/ItemDescription',
                'SalesOrderLines/Item',
                'SalesOrderLines/ItemCode',
                'SalesOrderLines/Quantity',
                'SalesOrderLines/NetPrice',
                'SalesOrderLines/VATCode',
                'SalesOrderLines/VATAmount',
            ]),

        ]);
    }

    public function createDtoFromResponse(Response $response): ?Order
    {
        return $this->orderMapper->map($response->json('d'));
    }
}
