<?php

namespace Daylight\Connector\Exact\Requests\Orders;

use Daylight\Connector\Entities\Order;
use Daylight\Connector\Exact\Mappers\OrderMapper;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;
use Saloon\Traits\Body\HasJsonBody;

class CreateOrderRequest extends Request implements HasBody
{
    use HasJsonBody;

    protected Method $method = Method::POST;

    public function __construct(
        protected OrderMapper $orderMapper,
        protected array $data = []
    ) {}

    public function resolveEndpoint(): string
    {
        return '/api/v1/'.config('services.exact.division').'/SalesOrder/SalesOrders';
    }

    protected function defaultBody(): array
    {
        return $this->data;
    }

    public function createDtoFromResponse(Response $response): ?Order
    {
        return $this->orderMapper->map($response->json('d'));
    }
}
