<?php

namespace Daylight\Connector\Exact\Requests\PricingLists;

use Daylight\Connector\Exact\Entities\PaginatedResource;
use Daylight\Connector\Exact\Mappers\PricingListMapper;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;

class GetPricingListsRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected PricingListMapper $pricingListMapper,
        protected array $options = []
    ) {
        //
    }

    public function resolveEndpoint(): string
    {
        return '/api/v1/'.config('services.exact.division').'/sales/SalesPriceLists';
    }

    public function defaultQuery(): array
    {
        return array_filter([
            '$skiptoken' => $this->options['skiptoken'] ?? null,
        ]);
    }

    public function createDtoFromResponse(Response $response): PaginatedResource
    {
        $formattedResponse = $response->json('d');

        return new PaginatedResource(
            data: collect($formattedResponse['results'] ?? [])->map(function (array $item) {
                return $this->pricingListMapper->map($item);
            }),
            skipToken: $formattedResponse['__next'] ?? null,
        );
    }
}
