<?php

namespace Daylight\Connector\Exact\Resources;

use Daylight\Connector\Contracts\MapperInterface;
use Saloon\Http\BaseResource;
use Saloon\Http\Response;

class Contacts extends BaseResource
{
    public function all(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Contacts\\GetContactsRequest',
            $mapper,
            $options
        );
    }

    public function get(MapperInterface $mapper, string $id, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Contacts\\GetContactRequest',
            $mapper,
            [
                'id' => $id,
                ...$options,
            ]
        );
    }
}
