<?php

namespace Daylight\Connector\Exact\Entities;

use Daylight\Connector\Entities\Order as BaseOrder;
use Spatie\LaravelData\Attributes\MapInputName;

class OrderLine extends BaseOrder
{
    public function __construct(
        #[MapInputName('ID')]
        public string $id,

        #[MapInputName('Item')]
        public string $articleId,

        #[MapInputName('ItemDescription')]
        public string $name,

        #[MapInputName('ItemCode')]
        public string $sku,

        #[MapInputName('LineNumber')]
        public int $order,

        #[MapInputName('NetPrice')]
        public float $price,

        #[MapInputName('VATAmount')]
        public float $taxAmount,

        #[MapInputName('Quantity')]
        public int $quantity,

        #[MapInputName('VATCode')]
        public ?string $taxCode = null,
    ) {
        //
    }

}
