<?php

namespace Daylight\Connector\Exact\Requests\WebhookSubscriptions;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class CreateWebhookSubscriptionRequest extends Request implements HasBody
{
    use HasJsonBody;

    protected Method $method = Method::POST;

    public function __construct(
        protected string $topic,
    ) {
        //
    }

    protected function defaultBody(): array
    {
        return [
            'CallbackURL' => route('exact.webhook'),
            'Topic' => $this->topic,
        ];
    }

    public function resolveEndpoint(): string
    {
        return '/api/v1/'.config('services.exact.division').'/webhooks/WebhookSubscriptions';
    }
}
