<?php

namespace Daylight\Connector\Exact\Resources;

use Daylight\Connector\Contracts\MapperInterface;
use Daylight\Connector\Resources\Orders as BaseOrdersResource;
use Saloon\Http\Response;

class Orders extends BaseOrdersResource
{
    public function all(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Orders\\GetOrdersRequest',
            $mapper,
            $options
        );
    }

    public function lines(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Orders\\GetOrderLinesRequest',
            $mapper,
            $options
        );
    }

    public function line(MapperInterface $mapper, string $id, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Orders\\GetOrderLineRequest',
            $mapper,
            [
                'id' => $id,
                ...$options,
            ]
        );
    }
}
