<?php

namespace Daylight\Connector\Exact\Console\Commands;

use Daylight\Core\Models\TaxClass;
use Illuminate\Console\Command;

class Install extends Command
{
    protected $signature = 'exact:install';

    protected $description = 'Set up Exact Online connector';

    public function handle(): int
    {
        $this->info('Installing Exact Online connector...');

        TaxClass::whereName('Standard')->update([
            'code' => '2  ',
            'external_id' => '45b8fe37-c316-48a8-b394-53be8a1f49f3',
        ]);

        TaxClass::whereName('Reduced')->update([
            'code' => '1  ',
            'external_id' => '18a9b320-0aac-41d6-abfb-6e0d9f1e1050',
        ]);

        TaxClass::whereName('Zero')->update([
            'code' => '0  ',
            'external_id' => '9f4f1bba-ae2e-43b4-9c1b-f4aa08bb10d6',
        ]);

        $this->line('Visit the following URL to complete authorization: '.route('exact.auth.redirect'));

        return Command::SUCCESS;
    }
}
