<?php

namespace Daylight\Connector\Exact\Models\Casts;

use Daylight\Connector\Exact\Exceptions\AccessTokenSerializationFailed;
use Illuminate\Contracts\Database\Eloquent\CastsAttributes;
use Illuminate\Support\Facades\Crypt;
use Saloon\Http\Auth\AccessTokenAuthenticator;

class EncryptedAccessTokenAuthenticator implements CastsAttributes
{
    public function get($model, string $key, $value, array $attributes): ?AccessTokenAuthenticator
    {
        if (is_null($value) || $value === '') {
            return null;
        }

        $serialized = Crypt::decryptString($value);

        return AccessTokenAuthenticator::unserialize($serialized);
    }

    public function set($model, string $key, $value, array $attributes): ?string
    {
        if (is_null($value)) {
            return null;
        }

        if ($value instanceof AccessTokenAuthenticator) {
            $serialized = $value->serialize();
        } elseif (is_string($value)) {
            $serialized = $value;
        } else {
            throw new AccessTokenSerializationFailed('Failed to serialize authenticator.');
        }

        return Crypt::encryptString($serialized);
    }
}
