<?php

namespace Daylight\Connector\Exact\Requests\Documents;

use Daylight\Connector\Exact\Entities\PaginatedResource;
use Daylight\Connector\Exact\Mappers\DocumentAttachmentMapper;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;

class GetDocumentAttachmentsRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected DocumentAttachmentMapper $documentAttachmentMapper,
        protected array $options = []
    ) {}

    public function resolveEndpoint(): string
    {
        return '/api/v1/'.config('services.exact.division').'/sync/Documents/DocumentAttachments';
    }

    public function defaultQuery(): array
    {
        return array_filter([
            '$select' => implode(',', [
                'ID',
                'Timestamp',
                'Document',
                'FileName',
                'FileSize',
                'Url',
            ]),
            '$skiptoken' => $this->options['skiptoken'] ?? null,
            '$filter' => $this->options['cursor'] ? "Timestamp gt {$this->options['cursor']}L" : null,
        ]);
    }

    public function createDtoFromResponse(Response $response): PaginatedResource
    {
        $formattedResponse = $response->json('d');

        return new PaginatedResource(
            data: collect($formattedResponse['results'] ?? [])->map(function (array $item) {
                return $this->documentAttachmentMapper->map($item);
            }),
            skipToken: $formattedResponse['__next'] ?? null,
        );
    }
}
