<?php

namespace Daylight\Connector\Exact\Requests\Orders;

use Daylight\Connector\Exact\Entities\OrderReference;
use Daylight\Connector\Exact\Mappers\OrderItemMapper;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;

class GetOrderLineRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected OrderItemMapper $orderItemMapper,
        protected array $options = []
    ) {}

    public function resolveEndpoint(): string
    {
        $guidFilter = isset($this->options['id'])
            ? "(guid'{$this->options['id']}')"
            : null;

        return '/api/v1/'.config('services.exact.division').'/salesorder/SalesOrderLines'.$guidFilter;
    }

    public function defaultQuery(): array
    {
        return array_filter([
            '$select' => implode(',', [
                'OrderID',
            ]),
        ]);
    }

    public function createDtoFromResponse(Response $response): ?OrderReference
    {
        return $this->orderItemMapper->mapReference($response->json('d'));
    }
}
