<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('variants', function (Blueprint $table) {
            $table->foreignId('unit_id')->after('product_id')->nullable()->constrained('units')->nullOnDelete();
            $table->string('name')->nullable()->after('sku');
            $table->string('external_id')->nullable()->after('weight');
        });
    }

    public function down(): void
    {
        Schema::table('variants', function (Blueprint $table) {
            $table->dropForeign(['unit_id']);
            $table->dropColumn('unit_id');
            $table->dropColumn('name');
            $table->dropColumn('external_id');
        });
    }
};
