<?php

namespace Daylight\Connector\Exact\Mappers;

use Daylight\Connector\Contracts\MapperInterface;
use Daylight\Connector\Entities\OrderItem;
use Daylight\Connector\Exact\Entities\OrderReference;

class OrderItemMapper implements MapperInterface
{
    public function map(array $data): OrderItem
    {
        return OrderItem::from($data);
    }

    public function mapReference(array $data): OrderReference
    {
        return OrderReference::from($data);
    }

    public function mapWithAttributes(array $data, array $attributes = []): OrderItem
    {
        return OrderItem::from([
            ...$data,
            ...$attributes,
        ]);
    }
}
