<?php

namespace Daylight\Connector\Exact\Mappers;

use Daylight\Connector\Contracts\MapperInterface;
use Daylight\Connector\Exact\Entities\Contact;

class ContactMapper implements MapperInterface
{
    public function map(array $data): Contact
    {
        return Contact::from($data);
    }

    public function mapWithAttributes(array $data, array $attributes = []): Contact
    {
        return Contact::from([
            ...$data,
            ...$attributes,
        ]);
    }
}
