<?php

namespace Daylight\Connector\Exact\Mappers;

use Daylight\Connector\Contracts\MapperInterface;
use Daylight\Connector\Exact\Entities\PricingList;

class PricingListMapper implements MapperInterface
{
    public function map(array $data): PricingList
    {
        return PricingList::from($data);
    }

    public function mapWithAttributes(array $data, array $attributes = []): PricingList
    {
        return PricingList::from([
            ...$data,
            ...$attributes,
        ]);
    }
}
