<?php

namespace Daylight\Connector\Exact;

use Daylight\Connector\Exact\Events\WebhookReceived;
use Daylight\Connector\Exact\Listeners\CreateOrderOnConnector;
use Daylight\Connector\Exact\Listeners\ProcessWebhook;
use Daylight\Core\Events\OrderCreated;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class ExactEventServiceProvider extends ServiceProvider
{
    protected $listen = [
        WebhookReceived::class => [
            ProcessWebhook::class,
        ],
        OrderCreated::class => [
            CreateOrderOnConnector::class,
        ],
    ];
}
