<?php

namespace Daylight\Connector\Exact\Http\Controllers;

use App\Http\Controllers\Controller;
use Daylight\Connector\Exact\Exact;
use Daylight\Connector\Exact\Http\Requests\OAuth2CallbackRequest;
use Daylight\Connector\Exact\TokenStorage;
use Illuminate\Http\RedirectResponse;

class OAuth2Controller extends Controller
{
    public function __construct(
        protected Exact $exact,
        protected TokenStorage $tokenStorage,
    ) {
        //
    }

    public function redirectToProvider(): RedirectResponse
    {
        return redirect()->to($this->exact->getAuthorizationUrl());
    }

    public function callback(OAuth2CallbackRequest $request)
    {
        $accessToken = $this->exact->getAccessToken(
            code: $request->code
        );

        $this->tokenStorage->persistInitialAuthenticator($accessToken);

        dd($this->tokenStorage->getAccessToken());
    }
}
