<?php

namespace Daylight\Connector\Exact\Http\Controllers;

use App\Http\Controllers\Controller;
use Daylight\Connector\Exact\Events\WebhookReceived;
use Daylight\Connector\Exact\Http\Requests\WebhookRequest;
use Log;

class WebhookController extends Controller
{
    public function __invoke(WebhookRequest $request)
    {
        WebhookReceived::dispatch($request->get('Content'));

        Log::channel('webhooks')->info('Exact Webhook Received', [
            'body' => $request->all(),
        ]);

        return response([
            'message' => 'Webhook received successfully',
        ], 201);
    }
}
