<?php

namespace Daylight\Connector\Exact\Mappers;

use Daylight\Connector\Contracts\MapperInterface;
use Daylight\Connector\Exact\Entities\DocumentAttachment;

class DocumentAttachmentMapper implements MapperInterface
{
    public function map(array $data): DocumentAttachment
    {
        return DocumentAttachment::from($data);
    }

    public function mapWithAttributes(array $data, array $attributes = []): DocumentAttachment
    {
        return DocumentAttachment::from([
            ...$data,
            ...$attributes,
        ]);
    }
}
