<?php

namespace Daylight\Connector\Exact\Mappers;

use Daylight\Connector\Contracts\MapperInterface;
use Daylight\Connector\Exact\Entities\Document;

class DocumentMapper implements MapperInterface
{
    public function map(array $data): Document
    {
        return Document::from($data);
    }

    public function mapWithAttributes(array $data, array $attributes = []): Document
    {
        return Document::from([
            ...$data,
            ...$attributes,
        ]);
    }
}
