<?php

namespace Daylight\Connector\Exact\Mappers;

use Daylight\Connector\Contracts\MapperInterface;
use Daylight\Connector\Exact\Entities\ProductPrice;

class ProductPriceMapper implements MapperInterface
{
    public function map(array $data): ProductPrice
    {
        return ProductPrice::from($data);
    }

    public function mapWithAttributes(array $data, array $attributes = []): ProductPrice
    {
        return ProductPrice::from([
            ...$data,
            ...$attributes,
        ]);
    }
}
