<?php

namespace Daylight\Connector\Exact\Requests\PricingLists;

use Daylight\Connector\Exact\Entities\PaginatedResource;
use Daylight\Connector\Exact\Mappers\PricingListLinesMapper;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;

class GetPricingListLinesRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected PricingListLinesMapper $pricingListLinesMapper,
        protected array $options = []
    ) {
        //
    }

    public function resolveEndpoint(): string
    {
        return '/api/v1/'.config('services.exact.division').'/sync/sales/SalesPriceListVolumeDiscounts';
    }

    public function defaultQuery(): array
    {
        return array_filter([
            '$select' => implode(',', [
                'ID',
                'Timestamp',
                'Item',
                'ItemGroup',
                'PriceListPeriod',
                'PriceListCode',
                'Quantity',
                'BasePrice',
                'BasePriceAmount',
                'NewPrice',
                'EntryMethod',
                'Discount',
            ]),
            '$skiptoken' => $this->options['skiptoken'] ?? null,
            '$filter' => $this->options['cursor'] ? "Timestamp gt {$this->options['cursor']}L" : null,
        ]);
    }

    public function createDtoFromResponse(Response $response): PaginatedResource
    {
        $formattedResponse = $response->json('d');

        return new PaginatedResource(
            data: collect($formattedResponse['results'] ?? [])->map(function (array $item) {
                return $this->pricingListLinesMapper->map($item);
            }),
            skipToken: $formattedResponse['__next'] ?? null,
        );
    }
}
