<?php

namespace Daylight\Connector\Exact\Requests\Units;

use Daylight\Connector\Exact\Mappers\UnitMapper;
use Illuminate\Support\Collection;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;

class GetUnitsRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected UnitMapper $unitMapper,
        protected array $options = []
    ) {
        //
    }

    public function resolveEndpoint(): string
    {
        return '/api/v1/'.config('services.exact.division').'/Logistics/Units';
    }

    public function defaultQuery(): array
    {
        return [];
    }

    public function createDtoFromResponse(Response $response): Collection
    {
        $formattedResponse = $response->json('d');

        return collect($formattedResponse['results'] ?? [])->map(function (array $item) {
            return $this->unitMapper->map($item);
        });
    }
}
