<?php

namespace Daylight\Connector\Exact\Entities;

use Carbon\Carbon;
use Daylight\Connector\Entities\Address as BaseAddress;
use Daylight\Connector\Exact\Entities\Casts\TimestampDateCast;
use Spatie\LaravelData\Attributes\MapInputName;
use Spatie\LaravelData\Attributes\WithCast;

class Document extends BaseAddress
{
    public function __construct(
        #[MapInputName('ID')]
        public string $id,

        #[MapInputName('Timestamp')]
        public int $timestamp,

        #[MapInputName('Account')]
        public ?string $customerId,

        #[MapInputName('DocumentDate')]
        #[WithCast(TimestampDateCast::class)]
        public ?Carbon $date,

        #[MapInputName('Type')]
        public int $type,

        #[MapInputName('SalesInvoiceNumber')]
        public ?int $invoiceNumber,
    ) {
        //
    }

    public function shouldBeImported(): bool
    {
        return $this->type === 10 && ! is_null($this->customerId);
    }
}
