<?php

namespace Daylight\Connector\Exact\Jobs;

use Daylight\Connector\Exact\Entities\Document;
use Daylight\Connector\Exact\Models\Invoice;
use Daylight\Core\Models\Customer;
use Illuminate\Bus\Batchable;
use Illuminate\Contracts\Queue\ShouldBeEncrypted;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class UpdateDocument implements ShouldBeEncrypted, ShouldBeUnique, ShouldQueue
{
    use Batchable, Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(
        public Document $document
    ) {
        //
    }

    public function handle(): void
    {
        if (! $this->document->shouldBeImported()) {
            return;
        }

        $customer = $this->getCustomer();

        if (! $customer) {
            return;
        }

        Invoice::create([
            'external_id' => $this->document->id,
            'customer_id' => $customer->id,
            'invoice_number' => $this->document->invoiceNumber,
            'invoice_date' => $this->document->date,
        ]);
    }

    public function getCustomer(): ?Customer
    {
        return daylightModel('customer')::query()
            ->whereExternalId($this->document->customerId)
            ->first();
    }
}
