<?php

namespace Daylight\Connector\Exact\Requests\Documents;

use Daylight\Connector\Exact\Mappers\DocumentAttachmentMapper;
use Saloon\Enums\Method;
use Saloon\Http\Request;

class DownloadAttachmentRequest extends Request
{
    protected Method $method = Method::GET;

    public function __construct(
        protected DocumentAttachmentMapper $documentAttachmentMapper,
        protected array $options = []
    ) {}

    public function resolveEndpoint(): string
    {
        return '/api/v1/'.config('services.exact.division').'/Documents/DocumentAttachments';
    }

    public function defaultQuery(): array
    {
        return array_filter([
            '$filter' => "ID eq guid'{$this->options['attachmentId']}'",
            '$select' => implode(',', [
                //                'ID',
                'Attachment',
                //                'Url',
            ]),
        ]);
    }
}
