<?php

namespace Daylight\Connector\Exact\Resources;

use Daylight\Connector\Contracts\MapperInterface;
use Saloon\Http\BaseResource;
use Saloon\Http\Response;

class Documents extends BaseResource
{
    public function all(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Documents\\GetDocumentsRequest',
            $mapper,
            $options
        );
    }

    public function attachments(MapperInterface $mapper, array $options = []): Response
    {
        return $this->connector->requestHandler(
            'Documents\\GetDocumentAttachmentsRequest',
            $mapper,
            $options
        );
    }

    public function download(MapperInterface $mapper, string $attachmentId): Response
    {
        return $this->connector->requestHandler(
            'Documents\\DownloadAttachmentRequest',
            $mapper,
            [
                'attachmentId' => $attachmentId,
            ]
        );
    }
}
