<?php

namespace Daylight\Connector\Exact\Entities;

use Daylight\Connector\Entities\Address as BaseAddress;
use Spatie\LaravelData\Attributes\MapInputName;

class Address extends BaseAddress
{
    public function __construct(
        #[MapInputName('ID')]
        public string $id,

        #[MapInputName('Timestamp')]
        public ?int $timestamp,

        #[MapInputName('Main')]
        public ?bool $isDefault,

        #[MapInputName('Type')]
        public ?int $type,

        #[MapInputName('Account')]
        public ?string $accountId = null,

        #[MapInputName('Postcode')]
        public ?string $postalCode = null,

        #[MapInputName('City')]
        public ?string $city = null,

        #[MapInputName('Country')]
        public ?string $country = null,

        #[MapInputName('AccountName')]
        public ?string $name = null,

        #[MapInputName('AddressLine1')]
        public ?string $addressLine1 = null,

        #[MapInputName('AddressLine2')]
        public ?string $addressLine2 = null,
    ) {
        //
    }

    public function shouldBeImported(): bool
    {
        return true;
    }

    public function getType(): string
    {
        return match ($this->type) {
            1, 2, 3 => 'billing',
            4 => 'shipping',
        };
    }
}
