<?php

namespace Daylight\Connector\Exact\Entities;

use Carbon\Carbon;
use Daylight\Connector\Exact\Entities\Casts\TimestampDateCast;
use Spatie\LaravelData\Attributes\MapInputName;
use Spatie\LaravelData\Attributes\WithCast;
use Spatie\LaravelData\Data;

class PricingListPeriod extends Data
{
    public function __construct(
        #[MapInputName('ID')]
        public ?string $id,

        #[MapInputName('PriceList')]
        public ?string $priceListId,

        #[MapInputName('StartDate')]
        #[WithCast(TimestampDateCast::class)]
        public ?Carbon $startDate = null,

        #[MapInputName('EndDate')]
        #[WithCast(TimestampDateCast::class)]
        public ?Carbon $endDate = null,
    ) {
        //
    }

}
