<?php

namespace Daylight\Connector\Exact\Entities;

use Daylight\Connector\Entities\Product as BaseProduct;
use Spatie\LaravelData\Attributes\MapInputName;

class Product extends BaseProduct
{
    public function __construct(
        #[MapInputName('ID')]
        public ?string $id,

        #[MapInputName('Timestamp')]
        public ?int $timestamp,

        #[MapInputName('Code')]
        public ?string $code,

        #[MapInputName('StandardSalesPrice')]
        public ?float $price,

        #[MapInputName('Description')]
        public ?string $name,

        #[MapInputName('IsStockItem')]
        public bool $stockItem,

        #[MapInputName('IsWebshopItem')]
        public bool $webshopItem,

        #[MapInputName('IsPurchaseItem')]
        public bool $purchaseItem,

        #[MapInputName('Stock')]
        public ?int $stock,

        #[MapInputName('Unit')]
        public ?string $unit,

        #[MapInputName('PictureUrl')]
        public ?string $imageUrl,

        #[MapInputName('ItemGroup')]
        public ?string $itemGroupId,

        #[MapInputName('ItemGroupCode')]
        public ?string $categoryCode,

        #[MapInputName('ItemGroupDescription')]
        public ?string $categoryName,

        #[MapInputName('SalesVatCode')]
        public ?string $taxCode = null,

        #[MapInputName('GrossWeight')]
        public ?float $weight = null,
    ) {
        //
    }

    public function canBePurchased(): bool
    {
        return $this->webshopItem;
    }

    public function availableOnBackorder(): bool
    {
        return $this->purchaseItem;
    }
}
