<?php

namespace Daylight\Connector\Exact\Entities;

use Carbon\Carbon;
use Daylight\Connector\Entities\Product as BaseProduct;
use Daylight\Connector\Exact\Entities\Casts\TimestampDateCast;
use Spatie\LaravelData\Attributes\MapInputName;
use Spatie\LaravelData\Attributes\WithCast;

class ProductPrice extends BaseProduct
{
    public function __construct(
        #[MapInputName('ID')]
        public string $id,

        #[MapInputName('Timestamp')]
        public int $timestamp,

        #[MapInputName('Account')]
        public ?string $customerId,

        #[MapInputName('Item')]
        public string $productId,

        #[MapInputName('ItemCode')]
        public string $sku,

        #[MapInputName('Quantity')]
        public int $quantity,

        #[MapInputName('Price')]
        public float $price,

        #[MapInputName('NumberOfItemsPerUnit')]
        public int $itemsPerUnit,

        #[MapInputName('StartDate')]
        #[WithCast(TimestampDateCast::class)]
        public ?Carbon $startDate,

        #[MapInputName('EndDate')]
        #[WithCast(TimestampDateCast::class)]
        public ?Carbon $endDate,
    ) {
        //
    }

}
