<?php

namespace Daylight\Connector\Exact\Mappers;

use Daylight\Connector\Contracts\MapperInterface;
use Daylight\Connector\Exact\Entities\ProductExtraField;

class ProductExtraFieldMapper implements MapperInterface
{
    public function map(array $data): ProductExtraField
    {
        return ProductExtraField::from($data);
    }

    public function mapWithAttributes(array $data, array $attributes = []): ProductExtraField
    {
        return ProductExtraField::from([
            ...$data,
            ...$attributes,
        ]);
    }
}
