<?php

namespace Daylight\Connector\Exact\Requests\Addresses;

use Daylight\Connector\Entities\Address;
use Daylight\Connector\Exact\Mappers\AddressMapper;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Http\Response;
use Saloon\Traits\Body\HasJsonBody;

class CreateAddressRequest extends Request implements HasBody
{
    use HasJsonBody;

    protected Method $method = Method::POST;

    public function __construct(
        protected AddressMapper $addressMapper,
        protected array $data = []
    ) {}

    public function resolveEndpoint(): string
    {
        return '/api/v1/'.config('services.exact.division').'/crm/Addresses';
    }

    protected function defaultBody(): array
    {
        return $this->data;
    }

    public function createDtoFromResponse(Response $response): ?Address
    {
        return $this->addressMapper->map($response->json('d'));
    }
}
