<?php

namespace Daylight\Connector\Exact\Jobs;

use Daylight\Connector\Exact\Entities\DocumentAttachment;
use Daylight\Connector\Exact\Models\Invoice;
use Illuminate\Bus\Batchable;
use Illuminate\Contracts\Queue\ShouldBeEncrypted;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class UpdateDocumentAttachment implements ShouldBeEncrypted, ShouldBeUnique, ShouldQueue
{
    use Batchable, Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(
        public DocumentAttachment $documentAttachment
    ) {
        //
    }

    public function handle(): void
    {
        $document = $this->getDocument();

        if (! $document) {
            return;
        }

        $document->attachments()->updateOrCreate([
            'external_id' => $this->documentAttachment->id,
        ], [
            'file_name' => $this->documentAttachment->fileName,
            'file_size' => $this->documentAttachment->fileSize,
            'url' => $this->documentAttachment->url,
        ]);
    }

    public function getDocument(): ?Invoice
    {
        return Invoice::query()
            ->whereExternalId($this->documentAttachment->documentId)
            ->first();
    }
}
