<?php

namespace Daylight\Connector\Exact\Console\Commands;

use Daylight\Connector\Exact\Entities\Unit;
use Daylight\Connector\Exact\Exact;
use Daylight\Connector\Exact\Models\Unit as UnitModel;
use Illuminate\Console\Command;
use Illuminate\Support\Collection;

class UpdateUnits extends Command
{
    protected $signature = 'exact:update-units';

    protected $description = 'Update units from Exact Online';

    public function handle(): int
    {
        $this->info('Updating units...');

        $response = $this->getItems();

        $response->each(function (Unit $unit) {
            UnitModel::updateOrCreate([
                'external_id' => $unit->id,
            ], [
                'code' => $unit->code,
                'name' => $unit->name,
                'display_text' => $unit->displayText,
                'type' => $unit->type,
                'active' => $unit->isActive ? 1 : 0,
            ]);
        });

        $this->info('Updated '.$response->count().' units from Exact Online.');

        return Command::SUCCESS;
    }

    protected function getItems(): ?Collection
    {
        return $this->connector()
            ->units()
            ->all(
                mapper: $this->connector()->getUnitMapper(),
            )
            ->dto();
    }

    private function connector(): Exact
    {
        return app(Exact::class);
    }
}
