@props([
    'items' => []
])


<div class="bg-gray-100 -mx-4 px-4 -mt-4 p-4 mb-4">
    <select
        @change="window.location.href = event.target.value"
        class="h-10 text-sm block w-full rounded-md border-0 py-1.5 pl-3 pr-10 text-gray-900 ring-1 ring-inset ring-gray-300 focus:ring-2 focus:ring-indigo-600 sm:text-sm sm:leading-6">
        @foreach($items as $item)
            @if(isset($item['spacer']))
                <option disabled>----</option>
            @else
                <option {{ $item['active'] ? 'selected' : '' }} value="{{ route($item['route']) }}">
                    {{ $item['title'] }}
                </option>
            @endif
        @endforeach
    </select>
</div>