<?php

namespace Daylight\Core\Models;

use Daylight\Core\Services\Tax;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Price extends Model
{
    protected $guarded = [];

    public function variant(): BelongsTo
    {
        return $this->belongsTo(daylightModel('variant'));
    }

    public function price(): Attribute
    {
        return Attribute::make(
            get: fn ($value) => $value / 100,
            set: fn ($value) => $value * 100,
        );
    }

    public function priceIncludingVat(): Attribute
    {
        return Attribute::make(
            get: function () {
                return $this->getRawOriginal('price') * (1 + Tax::defaultTaxRateForClass($this->variant->tax_class_id) / 100) / 100;
            }
        );
    }
}
