<?php

namespace Daylight\Core\Modules\Admin\Providers;

use Daylight\Core\Modules\Admin\Registries\WidgetRegistry;
use Daylight\Core\Modules\Admin\View\Composers\WidgetViewComposer;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class WidgetServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        $this->app->singleton(WidgetRegistry::class, function () {
            return new WidgetRegistry;
        });

        View::composer('daylight::dashboard', WidgetViewComposer::class);
    }
}
