<?php

namespace Daylight\Core\Modules\MediaLibrary\Http\Controllers\API;

use Daylight\Core\Http\Controllers\Controller;
use Daylight\Core\Modules\MediaLibrary\Http\Requests\StoreDirectoryRequest;
use Daylight\Core\Modules\MediaLibrary\Http\Requests\UpdateDirectoryRequest;
use Daylight\Core\Modules\MediaLibrary\Models\Directory;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;

class DirectoryController extends Controller implements HasMiddleware
{
    public static function middleware(): array
    {
        return [
            new Middleware('can:create:media', only: ['store']),
            new Middleware('can:update:media', only: ['update']),
            new Middleware('can:delete:media', only: ['destroy']),
        ];
    }

    public function store(StoreDirectoryRequest $request)
    {
        return Directory::create([
            'parent_id' => $request->input('parent_id'),
            'name' => $request->input('name'),
        ]);
    }

    public function update(UpdateDirectoryRequest $request, Directory $directory)
    {
        $directory->update($request->safe()->all());

        return $directory;
    }

    public function destroy(Directory $directory)
    {
        $directory->delete();

        return response()->json(null, 204);
    }
}
