@props([
    'label',
    'for' => null,
    'error' => null,
    'helpText' => null
])

<div {{ $attributes->merge(['class' => 'space-y-8 border-b border-gray-900/10 sm:pb-2 sm:space-y-0 sm:divide-y sm:divide-gray-900/10 sm:pb-0']) }}>
    <div class="sm:grid sm:grid-cols-12 sm:items-start sm:gap-4 py-4 sm:py-6">
        <label for="{{ $for }}" class="col-span-2 block text-sm font-medium leading-6 text-gray-900 sm:pt-1.5">{{ $label }}</label>
        <div class="mt-2 sm:col-span-10 sm:mt-0">
            {{ $slot }}

            @if ($error)
                <div class="mt-1 text-xs text-red-500">{{ $error }}</div>
            @endif

            @if ($helpText)
                <p class="mt-1 text-xs text-gray-500">{{ $helpText }}</p>
            @endif
        </div>
    </div>
</div>
