@extends('daylight::layouts.app')

@section('title', __('Create label'))

@section('content')
    <x-daylight::page-header :title="__('Create label')" />

    <x-daylight::session-messages/>

    <form method="post" action="{{ route('daylight.store.labels.store') }}">
        @csrf

        <x-daylight::input.group
            :label="__('Background')"
            :error="$errors->first('background')"
            for="background"
        >
            <x-daylight::input.color
                name="background"
                id="background"
                value="{{ old('background') }}"
                placeholder="#000000"
            />
        </x-daylight::input.group>

        <x-daylight::input.group
            :label="__('Text color')"
            :error="$errors->first('text_color')"
            for="text_color"
        >
            <x-daylight::input.color
                name="text_color"
                id="text_color"
                value="{{ old('text_color') }}"
                placeholder="#FFFFFF"
            />
        </x-daylight::input.group>

        <div class="mt-6">
            <h2 class="text-lg leading-loose font-medium">{{ __('daylight::general.translations') }}</h2>
        </div>

        @foreach(\Daylight\Core\Modules\Multilingualism\Multilingualism::getAvailableLocales() as $locale)
            <x-daylight::input.group
                :label="__('Name (:locale)', ['locale' => strtoupper($locale)])"
                :error="$errors->first('translations.' . $locale . '.name')"
                for="translations[{{ $locale }}][name]"
            >
                <x-daylight::input.text
                    name="translations[{{ $locale }}][name]"
                    id="translations[{{ $locale }}][name]"
                    value="{{ old('translations.' . $locale . '.name') }}"
                    :disabled="!auth()->user()->can('update:labels')"
                />
            </x-daylight::input.group>
        @endforeach

        <div class="mt-6 flex items-center justify-end gap-x-3">
            <x-daylight::buttons.secondary href="{{ route('daylight.store.labels.index') }}" element="a">
                {{ __('daylight::general.cancel') }}
            </x-daylight::buttons.secondary>

            <x-daylight::buttons.primary type="submit">
                {{ __('daylight::general.save') }}
            </x-daylight::buttons.primary>
        </div>
    </form>
@endsection
