<?php

namespace Daylight\Core\Models\Shipping;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class ShippingClass extends Model
{
    protected $guarded = [];

    protected $casts = [
        'default' => 'bool',
        'cumulative' => 'bool',
        'taxable' => 'bool',
    ];

    public function variants(): BelongsToMany
    {
        return $this->belongsToMany(daylightModel('variant'));
    }

    public function shippingZones(): BelongsToMany
    {
        return $this->belongsToMany(daylightModel('shipping_zone'));
    }

    public function taxClass(): BelongsTo
    {
        return $this->belongsTo(daylightModel('tax_class'));
    }
}
