<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Storage Disk
    |--------------------------------------------------------------------------
    |
    | The disk where media files will be stored. This can be 'public', 's3',
    | or any other disk configured in config/filesystems.php.
    |
    */

    'disk' => env('MEDIA_DISK', 'public'),

    /*
    |--------------------------------------------------------------------------
    | Maximum File Size
    |--------------------------------------------------------------------------
    |
    | Maximum file size in kilobytes (32MB = 32768KB)
    |
    */

    'max_size' => 32768,

    /*
    |--------------------------------------------------------------------------
    | Accepted MIME Types
    |--------------------------------------------------------------------------
    |
    | Array of accepted MIME types for file uploads
    |
    */

    'accepted_mimes' => [
        // Images
        'image/jpeg',
        'image/jpg',
        'image/pjpeg', // Progressive JPEG
        'image/png',
        'image/x-png', // Alternative PNG mime type
        'image/gif',
        'image/webp',
        'image/svg+xml',

        // Videos
        'video/mp4',
        'video/quicktime',
        'video/x-msvideo',
        'video/webm',

        // Documents
        'application/pdf',
        'application/msword',
        'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
        'application/vnd.ms-excel',
        'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
    ],

    /*
    |--------------------------------------------------------------------------
    | Image Conversions
    |--------------------------------------------------------------------------
    |
    | Define image conversions that will be automatically generated when
    | an image is uploaded. Each conversion will be processed as a queue job.
    |
    */

    'conversions' => [
        'thumbnail' => [
            'width' => 300,
            'height' => 300,
            'quality' => 85,
            'format' => 'jpg',
            'crop' => true,
        ],

        'thumbnail-2x' => [
            'width' => 600,
            'height' => 600,
            'quality' => 85,
            'format' => 'jpg',
            'crop' => true,
        ],

        'thumbnail-webp' => [
            'width' => 300,
            'height' => 300,
            'quality' => 85,
            'format' => 'webp',
            'crop' => true,
        ],

        'medium' => [
            'width' => 800,
            'height' => 800,
            'quality' => 90,
            'format' => 'jpg',
            'crop' => true,
        ],

        'large' => [
            'width' => 1600,
            'height' => 1600,
            'quality' => 90,
            'format' => 'jpg',
            'crop' => true,
        ],

        'large-webp' => [
            'width' => 1600,
            'height' => 1600,
            'quality' => 85,
            'format' => 'webp',
            'crop' => true,
        ],
    ],

];
